#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -------------------------------------------------------------------------------------
# Ten plik jest przykładem podstawowej wtyczki Python dla GIMP.
# Może być wykonana poprzez wybranie z menu opcji: "/TEST/Hello world!" (Witaj, świecie!)"


from gimpfu import *

def Display_hello_world(img, layer) :
    '''
	Wtyczka nic nie robi, tylko po ustawieniu wskaźnika myszki na 
	Etykiecie (nazwie punktu w menu), obok wskaźnika oraz na pasku 
	stanu w dole okna Edytora obrazów GIMP wyświetli się komunikat 
	"Hello World!"
    
    Parametery:
    img : image - Aktualny obraz.
    layer : warstwa aktualnego obrazu.
    '''
    gimp_message("Hello world!")  # Wyświetla komunikat w oknie dialogowym 
								  # Przydatne do statusu lub raportowania błędów.
								  # Komunikat musi być w UTF-8

	
register(
    "test_hello_world", 
    "Hello world!",
    "Wyświetla komunikat 'Hello world!' ",
    "Zbyma",
    "Open source",
    "2015",
    "Hello world!", # Etykieta, nazwa punktu w menu, za pomocą której, wtyczka będzie uruchamiana,
	
    "*", # Typ obrazu: z którym wtyczka może współpracować, przy tym oznaczeniu Nasza 
		 # wtyczka obsługuje wszystkie typy obrazów (ale przy tym oznaczeniu, 
		 # bez obrazu Etykieta będzie wyszarzona), jeśli mamy puste "", 
		 # wtyczka jest dostępna nawet wtedy, gdy nie ma otwartego obrazu.
    [],
    [],
    Display_hello_world, menu="<Image>/TEST/" # Nazwa podana w def wywoływana 
	# Naszym kodem oraz Ścieżka do punktu menu GIMP-a, gdzie powinna się znajdować 
	# Etykieta wtyczki, (ścieżka do menu musi startować z np. <Image> lub <Toolbox> 
	# czy <Layers>, wszędzie gdzie czujemy jej miejsce)  
	)
main()